/* Fernando Filippetti #93684 
Recorre la matriz en sigzag, en diagonal hacia arriba*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>


/* Tamaño de la matrix a generar */
#define COLS 5
#define FILS 8

struct nodo
{
    int col;
    char fil;
    struct nodo *sig;
    struct nodo *prox;
};

typedef struct nodo tnodo;
typedef enum est_ant {SUBIENDO,BAJANDO,SUB_DIAG,BAJ_DIAG,DERECHA} testado;

tnodo *dir_a_punt(tnodo *VE[], int fil,int col)
{
    tnodo *aux;
    int i;
    aux= VE[fil];
    for (i=0; i<col; i++)
    {
        aux=aux->sig;
    }
//fprintf(stderr," (%c%d)\t",aux->fil,aux->col);
    return aux;
}

void enganchar_recursiv(tnodo *VE[],int C,int N,int n_act, int c_act, tnodo * nodo_act, testado Es)
{
    if(n_act == 0 && c_act ==C-1) return;

    else if ( c_act > 0 && Es==DERECHA)
    {
        nodo_act->prox=dir_a_punt(VE,n_act-1,c_act-1);
        enganchar_recursiv(VE,C,N,n_act-1,c_act-1,nodo_act->prox,SUB_DIAG);
    }
    else if (n_act > 0 && Es==SUB_DIAG && c_act == 0)
    {
        nodo_act->prox=dir_a_punt(VE,n_act-1,c_act);
        enganchar_recursiv(VE,C,N,n_act-1,c_act,nodo_act->prox,SUBIENDO);
    }
    else if (n_act < N  && Es==SUBIENDO && c_act == 0)
    {
        nodo_act->prox=dir_a_punt(VE,n_act+1,c_act+1);
        enganchar_recursiv(VE,C,N,n_act+1,c_act+1,nodo_act->prox,BAJ_DIAG);
    }
    else if (n_act < N-1 && Es==BAJ_DIAG && c_act < C-1)
    {
        nodo_act->prox=dir_a_punt(VE,n_act+1,c_act+1);
        enganchar_recursiv(VE,C,N,n_act+1,c_act+1,nodo_act->prox,BAJ_DIAG);
    }
    else if (n_act == N-1 && Es==BAJ_DIAG && c_act < C-1)
    {
        nodo_act->prox=dir_a_punt(VE,n_act,c_act+1);
        enganchar_recursiv(VE,C,N,n_act,c_act+1,nodo_act->prox,DERECHA);
    }
    else if (Es==SUB_DIAG && c_act > 0 && n_act >0)
    {
        nodo_act->prox=dir_a_punt(VE,n_act-1,c_act-1);
        enganchar_recursiv(VE,C,N,n_act-1,c_act-1,nodo_act->prox,SUB_DIAG);
    }
    else if (Es==BAJ_DIAG && n_act ==N-1)
    {
        nodo_act->prox=dir_a_punt(VE,n_act-1,c_act);
        enganchar_recursiv(VE,C,N,n_act-1,c_act,nodo_act->prox,SUBIENDO);
    }
    else if (Es==SUBIENDO && c_act == C-1)
    {
        nodo_act->prox=dir_a_punt(VE,n_act-1,c_act-1);
        enganchar_recursiv(VE,C,N,n_act-1,c_act-1,nodo_act->prox,SUB_DIAG);
    }
    else if (Es==SUB_DIAG && n_act == 0)
    {
        nodo_act->prox=dir_a_punt(VE,n_act,c_act+1);
        enganchar_recursiv(VE,C,N,n_act,c_act+1,nodo_act->prox,BAJ_DIAG);
    }
    else if (Es==BAJ_DIAG && c_act == C-1)
    {
        nodo_act->prox=dir_a_punt(VE,n_act-1,c_act);
        enganchar_recursiv(VE,C,N,n_act-1,c_act,nodo_act->prox,SUBIENDO);
    }
}

void enganchar(tnodo *VE[],int N,int C)
{
    //VE[N]->prox=VE[N]->sig;
    enganchar_recursiv(VE,C,N,N-1,0,VE[N-1],BAJ_DIAG);

}

void Imprimir_Lista_prox(tnodo *el_nodo) /* Imprime la lista por "prox"*/
{
    if(el_nodo==NULL)return;
    printf(" %c%d\t",el_nodo->fil,el_nodo->col);
    Imprimir_Lista_prox(el_nodo->prox);
}

void Imprimir_Lista_sig(tnodo *lista[]) /* Imprime la matriz completa*/
{
    int i;
    tnodo *aux;
    puts(" ");
    for(i=0; i<FILS && lista[i] != NULL; i++)
    {
        aux=lista[i];
        while( aux != NULL)
        {
            printf(" %c%d\t",aux->fil,aux->col);
            if(aux->sig != NULL)
                aux=aux->sig;
            else
                aux=NULL;
        }
        puts(" ");
    }
}


int main()
{
    tnodo *Ve[FILS+1];
    int i,j;
    tnodo *aux;
    printf("Comienzo\n");
    for(i=0; i<FILS; i++)
    {
        (Ve[i])=calloc(1,sizeof(tnodo));//pido memoria para el primer nodo
        aux=Ve[i];
        aux->fil = 'A'+i;
        aux->col = 0;
        for(j=1; j < COLS ; j++)
        {
            aux->sig=calloc(1,sizeof(tnodo));//pido memoria para en nodo siguiente
            aux=aux->sig;//me paro en el nodo siguiente,
            aux->sig=NULL;//nulleo el ultimo.
            aux->fil = 'A'+i;
            aux->col = j;
        }
    }
    Ve[FILS]=NULL;
    Imprimir_Lista_sig(Ve);
    puts("-------------------------");
    puts("Recorriendo la lista por Prox");
    enganchar(Ve,FILS,COLS);
    Imprimir_Lista_prox(Ve[FILS-1]);


    return 0;
}

